# Stardew Valley

## Where is the options page?

The [player options page for this game](../player-options) contains all the options you need to configure and export a
config file.

## What does randomization do to this game?

A vast number of objectives in Stardew Valley can be shuffled around the multiworld. Most of these are optional, and the
player can customize their experience in their YAML file.

For these objectives, if they have a vanilla reward, this reward will instead be an item in the multiworld. For the remaining
number of such objectives, there are a number of "Resource Pack" items, which are simply an item or a stack of items that
may be useful to the player.

## What is the goal of Stardew Valley?

The player can choose from a number of goals, using their YAML options.

- Complete the [Community Center](https://stardewvalleywiki.com/Bundles)
- Succeed [Grandpa's Evaluation](https://stardewvalleywiki.com/Grandpa) with 4 lit candles
- Reach the bottom of the [Pelican Town Mineshaft](https://stardewvalleywiki.com/The_Mines)
- Complete the [Cryptic Note](https://stardewvalleywiki.com/Secret_Notes#Secret_Note_.2310) quest, by meeting Mr Qi on
  floor 100 of the Skull Cavern
- Become a [Master Angler](https://stardewvalleywiki.com/Fish), which requires catching every fish in your slot
- Restore [A Complete Collection](https://stardewvalleywiki.com/Museum), which requires donating all the artifacts and
  minerals to the museum
- Get the achievement [Full House](https://stardewvalleywiki.com/Children), which requires getting married and having two kids
- Get recognized as the [Greatest Walnut Hunter](https://stardewvalleywiki.com/Golden_Walnut) by Mr Qi, which requires
  finding all 130 golden walnuts on ginger island
- Become the [Protector of the Valley](https://stardewvalleywiki.com/Adventurer%27s_Guild#Monster_Eradication_Goals) by
  completing all the monster slayer goals at the Adventure Guild
- Complete a [Full Shipment](https://stardewvalleywiki.com/Shipping#Collection) by shipping every item in your slot
- Become a [Gourmet Chef](https://stardewvalleywiki.com/Cooking) by cooking every recipe in your slot
- Become a [Craft Master](https://stardewvalleywiki.com/Crafting) by crafting every item
- Earn the title of [Legend](https://stardewvalleywiki.com/Gold) by earning 10 000 000g
- Solve the [Mystery of the Stardrops](https://stardewvalleywiki.com/Stardrop) by finding every stardrop
- Find and wear every [Hat](https://stardewvalleywiki.com/Hats) in the game.
- Find and eat every item in the game.
- Finish 100% of your randomizer slot with Allsanity: Complete every check in your slot
- Achieve [Perfection](https://stardewvalleywiki.com/Perfection) in your save file

The following goals [Community Center, Master Angler, Protector of the Valley, Full Shipment, Gourmet Chef and Mad Hatter] will adapt
to other options in your slots, and are therefore customizable in duration and difficulty. For example, if you set "Fishsanity"
to "Exclude Legendaries", and pick the Master Angler goal, you will not need to catch the legendaries to complete the goal.

## What are location checks in Stardew Valley?

Location checks in Stardew Valley always include:

- [Community Center Bundles](https://stardewvalleywiki.com/Bundles)
- [Mineshaft Chest Rewards](https://stardewvalleywiki.com/The_Mines#Remixed_Rewards)
- [Traveling Merchant Items](https://stardewvalleywiki.com/Traveling_Cart)
- Isolated objectives such as the [beach bridge](https://stardewvalleywiki.com/The_Beach#Tide_Pools),
  [Old Master Cannoli](https://stardewvalleywiki.com/Secret_Woods#Old_Master_Cannoli),
  [Grim Reaper Statue](https://stardewvalleywiki.com/Golden_Scythe), etc

There also are a number of location checks that are optional, and individual players choose to include them or not in their shuffling:

- [Tools and Fishing Rod Upgrades](https://stardewvalleywiki.com/Tools)
- [Carpenter Buildings](https://stardewvalleywiki.com/Carpenter%27s_Shop#Farm_Buildings)
- [Backpack Upgrades](https://stardewvalleywiki.com/Tools#Other_Tools)
- [Mine Elevator Levels](https://stardewvalleywiki.com/The_Mines#Staircases)
- [Skill Levels](https://stardewvalleywiki.com/Skills) and [Masteries](https://stardewvalleywiki.com/Mastery_Cave#Masteries)
- Arcade Machines
- [Story Quests](https://stardewvalleywiki.com/Quests#List_of_Story_Quests)
- [Help Wanted Quests](https://stardewvalleywiki.com/Quests#Help_Wanted_Quests)
- Participating in [Festivals](https://stardewvalleywiki.com/Festivals)
- [Special Orders](https://stardewvalleywiki.com/Quests#List_of_Special_Orders) from the town board, or from
  [Mr Qi](https://stardewvalleywiki.com/Quests#List_of_Mr._Qi.27s_Special_Orders)
- [Cropsanity](https://stardewvalleywiki.com/Crops): Growing and Harvesting individual crop types
- [Fishsanity](https://stardewvalleywiki.com/Fish): Catching individual fish
- [Museumsanity](https://stardewvalleywiki.com/Museum): Donating individual items, or reaching milestones for museum donations
- [Friendsanity](https://stardewvalleywiki.com/Friendship): Reaching specific friendship levels with NPCs
- [Monstersanity](https://stardewvalleywiki.com/Adventurer%27s_Guild#Monster_Eradication_Goals): Completing monster slayer goals
- [Cooksanity](https://stardewvalleywiki.com/Cooking): Cooking individual recipes
- [Chefsanity](https://stardewvalleywiki.com/Cooking#Recipes): Learning cooking recipes
- [Craftsanity](https://stardewvalleywiki.com/Crafting): Crafting individual items
- [Shipsanity](https://stardewvalleywiki.com/Shipping): Shipping individual items
- [Booksanity](https://stardewvalleywiki.com/Books): Reading individual books
- [Walnutsanity](https://stardewvalleywiki.com/Golden_Walnut): Collecting Walnuts on Ginger Island
- [Hatsanity](https://stardewvalleywiki.com/Hats): Wear individual Hats
- [Secretsanity](https://stardewvalleywiki.com/Secrets): Find secrets and easter eggs
- [Moviesanity](https://stardewvalleywiki.com/Movie_Theater): Watch movies with villagers and optionally share snacks with them
- Eatsanity: Eat every item in the game

And more!

## Which items can be in another player's world?

Every normal reward from the above locations can be in another player's world.
For the locations which do not include a normal reward, Resource Packs and traps are instead added to the pool. Traps are optional.

A player can enable some options that will add some items to the pool that are relevant to progression

- Seasons Randomizer:
    - All 4 seasons will be items, and one of them will be selected randomly and be added to the player's start inventory.
    - At the end of each month, the player can choose the next season, instead of following the vanilla season order. On Seasons Randomizer, they can only
      choose from the seasons they have received.
- Cropsanity:
    - Every single seed in the game starts off locked and cannot be purchased from any merchant. Their unlocks are received as multiworld items. Growing each
      seed and harvesting the resulting crop sends a location check
    - The way merchants sell seeds is considerably changed. Pierre sells fewer seeds at a high price, while Joja sells unlimited seeds but in huge discount
      packs, not individually.
- Museumsanity:
    - The items that are normally obtained from museum donation milestones are added to the item pool. Some items, like the magic rock candy, are duplicated for
      convenience.
    - The Traveling Merchant now sells artifacts and minerals, with a bias towards undonated ones, to mitigate randomness. She will sell these items as the
      player receives "Traveling Merchant Metal Detector" items.
- TV Channels
- Babies
    - Only if Friendsanity is enabled

There are a few extra vanilla items, which are added to the pool for convenience, but do not have a matching location. These include

- [Wizard Buildings](https://stardewvalleywiki.com/Wizard%27s_Tower#Buildings)
- [Return Scepter](https://stardewvalleywiki.com/Return_Scepter)
- [Qi Walnut Room QoL items](https://stardewvalleywiki.com/Qi%27s_Walnut_Room#Stock)

And lastly, some Archipelago-exclusive items exist in the pool, which are designed around game balance and QoL. These include:

- Arcade Machine buffs (Only if the arcade machines are randomized)
    - Journey of the Prairie King has drop rate increases, extra lives, and equipment
    - Junimo Kart has extra lives.
- Permanent Movement Speed Bonuses (customizable)
- Various Permanent Player Buffs (customizable)
- Traveling Merchant modifiers

## When the player receives an item, what happens?

Since Pelican Town is a remote area, it takes one business day for every item to reach the player. If an item is received
while online, it will appear in the player's mailbox the next morning, with a message from the sender telling them where
it was found. If an item is received while offline, it will be in the mailbox as soon as the player logs in.

Some items will be directly attached to the letter, while some others will instead be a world-wide unlock, and the letter
only serves to tell the player about it.

In some cases, like receiving Carpenter and Wizard buildings, the player will still need to go ask Robin to construct the
building that they have received, so they can choose its position. This construction will be completely free.

## Mods

Some Stardew Valley mods unrelated to Archipelago are officially "supported".
This means that, for these specific mods, if you decide to include them in your yaml options, the multiworld will be generated
with the assumption that you will install and play with these mods. The multiworld will contain related items and locations
for these mods, the specifics will vary from mod to mod

[Supported Mods Documentation](https://github.com/agilbert1412/StardewArchipelago/blob/7.x.x/Documentation/Supported%20Mods.md)

List of supported mods:

- General
    - [Skull Cavern Elevator](https://www.nexusmods.com/stardewvalley/mods/963)
    - [Bigger Backpack](https://www.nexusmods.com/stardewvalley/mods/1845)
    - [Tractor Mod](https://www.nexusmods.com/stardewvalley/mods/1401)
    - [Distant Lands - Witch Swamp Overhaul](https://www.nexusmods.com/stardewvalley/mods/18109)
- Skills
    - [Luck Skill](https://www.nexusmods.com/stardewvalley/mods/521)
    - [Socializing Skill](https://www.nexusmods.com/stardewvalley/mods/14142)
    - [Archaeology](https://www.nexusmods.com/stardewvalley/mods/22199)
    - [Binning Skill](https://www.nexusmods.com/stardewvalley/mods/14073)
- NPCs
    - [Ayeisha - The Postal Worker (Custom NPC)](https://www.nexusmods.com/stardewvalley/mods/6427)
    - [Mister Ginger (cat npc)](https://www.nexusmods.com/stardewvalley/mods/5295)
    - [Juna - Roommate NPC](https://www.nexusmods.com/stardewvalley/mods/8606)
    - [Professor Jasper Thomas](https://www.nexusmods.com/stardewvalley/mods/5599)
    - [Alec Revisited](https://www.nexusmods.com/stardewvalley/mods/10697)
    - [Custom NPC Eugene](https://www.nexusmods.com/stardewvalley/mods/9222)
    - [Alecto the Witch](https://www.nexusmods.com/stardewvalley/mods/10671)

Some of these mods might need a patch mod to tie the randomizer with the mod. These can be found
[here](https://github.com/Witchybun/SDV-Randomizer-Content-Patcher/releases)

## Multiplayer

You cannot play an Archipelago Slot in multiplayer at the moment. There are no short-term plans to support that feature.

You can, however, send Stardew Valley objects as gifts from one Stardew Player to another Stardew, or a player in another game that supports gifting, using
in-game Joja Prime delivery, for a fee. This exclusive feature can be turned off if you don't want to send and receive gifts.
